/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.ui.bonsai.servlet.util;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.managed.User;
import com.ibm.hwmca.fw.servlet.pmod.task.PanelModelTaskPortal;
import com.ibm.hwmca.fw.servlet.util.HMCSession;
import com.ibm.hwmca.fw.servlet.util.HMCSessionListener;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.ui.UIClient;
import com.ibm.hwmca.fw.ui.UIException;
import com.ibm.hwmca.fw.ui.UIObjects;
import com.ibm.hwmca.fw.ui.UIObjectsReader;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.ui.bonsai.BonsaiUIStyle;
import com.ibm.hwmca.ui.bonsai.earth.BonsaiTreeManager;
import com.ibm.hwmca.ui.bonsai.earth.TaskManager;
import com.ibm.hwmca.ui.bonsai.servlet.BonsaiSettingsListener;
import com.ibm.hwmca.ui.bonsai.servlet.util.UIRefreshManager;
import com.ibm.hwmca.ui.bonsai.status.StatusMonitorManager;
import com.ibm.hwmca.ui.bonsai.tree.NavigationTreeSelectionListener;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class UserObject
implements Serializable {
    private static final String TRACEMASK_T = "XBUISEST";
    private static final String TRACEMASK_F = "XBUISESF";
    private static final String TRACEMASK_D = "XBUISESD";
    private static final String SESSION_KEY = "com.ibm.hwmca.ui.bonsai.servlet.util.UserObject";
    private final Object REQUEST_LOCK = new Object();
    private final Object TASK_CACHE_LOCK = new Object();
    private final Object TREE_SELECTION_LOCK = new Object();
    private final Object TABLE_SELECTION_LOCK = new Object();
    private final Object VISIBILITY_LOCK = new Object();
    private HMCSession hmcSession;
    private Set userRoles;
    private UIObjects uiObjects;
    private StatusMonitorManager statusManager;
    private boolean activeSelectionInTree;
    private String treeSelection;
    private Set selectionListeners;
    private List tableSelection;
    private List tableSelectionTaskTrees;
    private Map visibleModels;

    public synchronized void init(HMCSession hmcSession) throws TaskletException, UIException, HException {
        Trace.trace(TRACEMASK_F, "--> UserObject.init(" + hmcSession + ")");
        if (hmcSession == null) {
            throw new IllegalStateException("HMCSession has not yet been set!");
        }
        this.hmcSession = hmcSession;
        this.uiObjects = new UIObjects(hmcSession);
        UIClient client = this.uiObjects.getUIClient();
        client.addUserSettingsListener(new BonsaiSettingsListener(this));
        this.userRoles = User.getUser(hmcSession.getUserContext().getUserName()).getUserRoles();
        this.statusManager = new StatusMonitorManager(this);
        this.visibleModels = new HashMap(5);
        this.treeSelection = "";
        this.selectionListeners = new HashSet(4);
        hmcSession.setSessionAttribute(SESSION_KEY, this);
        hmcSession.addHMCSessionListener(new UserObjectSessionListener());
        BonsaiUIStyle.addUserObject(this);
        Trace.trace(TRACEMASK_F, "<-- UserObject.init()");
    }

    public Object getRequestLock() {
        return this.REQUEST_LOCK;
    }

    public Locale getLocale() {
        return this.hmcSession.getUserContext().getLocale();
    }

    public UIClient getUIClient() {
        return this.uiObjects.getUIClient();
    }

    public UIObjectsReader getUIObjectsReader() {
        return this.uiObjects.getUIObjectsReader();
    }

    public Set getUserRoles() {
        return this.userRoles;
    }

    public StatusMonitorManager getStatusMonitorManager() {
        return this.statusManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActiveSelectionInTree() {
        Object object = this.TASK_CACHE_LOCK;
        synchronized (object) {
            return this.activeSelectionInTree;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActiveSelectionInTree(boolean activeSelectionInTree) {
        Object object = this.TASK_CACHE_LOCK;
        synchronized (object) {
            this.activeSelectionInTree = activeSelectionInTree;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTreeSelection() {
        Object object = this.TREE_SELECTION_LOCK;
        synchronized (object) {
            return this.treeSelection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setTreeSelection(String newTreeSelection) {
        Object object = this.TREE_SELECTION_LOCK;
        synchronized (object) {
            String oldTreeSelection = this.treeSelection;
            if (oldTreeSelection.equals(newTreeSelection)) {
                return false;
            }
            this.treeSelection = newTreeSelection;
            Iterator i = this.getTreeSelectionListeners().iterator();
            while (i.hasNext()) {
                ((NavigationTreeSelectionListener)i.next()).treeSelectionChanged(oldTreeSelection, newTreeSelection);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTreeSelectionListener(NavigationTreeSelectionListener listener) {
        Set set = this.selectionListeners;
        synchronized (set) {
            this.selectionListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set getTreeSelectionListeners() {
        Set set = this.selectionListeners;
        synchronized (set) {
            return new HashSet(this.selectionListeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTreeSelectionListener(NavigationTreeSelectionListener listener) {
        Set set = this.selectionListeners;
        synchronized (set) {
            this.selectionListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getTableSelection() {
        Object object = this.TABLE_SELECTION_LOCK;
        synchronized (object) {
            return this.tableSelection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTableSelection(List tableSelection) {
        Object object = this.TABLE_SELECTION_LOCK;
        synchronized (object) {
            this.tableSelection = tableSelection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getResourceTaskTrees() {
        Object object = this.TASK_CACHE_LOCK;
        synchronized (object) {
            if (this.activeSelectionInTree) {
                Object object2 = this.TREE_SELECTION_LOCK;
                synchronized (object2) {
                    return TaskManager.getTaskManager().getTasks(BonsaiTreeManager.getBonsaiTreeManager().getTreeNode(this.treeSelection), this);
                }
            }
            return this.tableSelectionTaskTrees;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTableSelectionTaskTrees(List taskNodes) {
        Object object = this.TASK_CACHE_LOCK;
        synchronized (object) {
            this.tableSelectionTaskTrees = taskNodes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isModelVisible(String modelKey) {
        Object object = this.VISIBILITY_LOCK;
        synchronized (object) {
            return this.visibleModels.containsValue(modelKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getVisibleModel(String key) {
        Object object = this.VISIBILITY_LOCK;
        synchronized (object) {
            return this.visibleModels.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setModelVisible(String key, String modelKey) {
        Object object = this.VISIBILITY_LOCK;
        synchronized (object) {
            this.visibleModels.put(key, modelKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setModelInvisible(String key) {
        Object object = this.VISIBILITY_LOCK;
        synchronized (object) {
            this.visibleModels.remove(key);
        }
    }

    public HMCSession getHMCSession() {
        return this.hmcSession;
    }

    public static UserObject getUserObject(HMCSession hmcSession) {
        return (UserObject)hmcSession.getSessionAttribute(SESSION_KEY);
    }

    public String toString() {
        return "UserObject." + this.hmcSession.getUserContext().getUserName() + "." + this.hmcSession.getDisplayableSessionId();
    }

    private class UserObjectSessionListener
    implements HMCSessionListener {
        private UserObjectSessionListener() {
        }

        public void sessionConnected(HMCSession session) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sessionDisconnected(HMCSession session) {
            Object object = UserObject.this.VISIBILITY_LOCK;
            synchronized (object) {
                UserObject.this.visibleModels.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sessionDestroyed(HMCSession session) {
            StatusMonitorManager statusMonitorManager = UserObject.this.statusManager;
            synchronized (statusMonitorManager) {
                UserObject.this.statusManager.destroy();
                BonsaiUIStyle.removeUserObject(UserObject.this);
            }
        }

        public void clientConnectivityLost(HMCSession session) {
        }

        public void clientConnectivityGained(final HMCSession session) {
            new Thread("UserObject.UserObjectSessionListener.clientConnectivityGained() handler"){

                public void run() {
                    UIRefreshManager.refresh(0, session);
                }
            }.start();
        }

        public void taskStarted(HMCSession session, PanelModelTaskPortal portal) {
        }

        public void taskRealized(HMCSession session, PanelModelTaskPortal portal) {
        }

        public void taskEnded(HMCSession session, PanelModelTaskPortal portal) {
        }
    }
}

